import bluetooth                  # 匯入藍牙模組         
from machine import Pin    

led = Pin('C13', Pin.OUT)
led.value(0)                      # 預設熄燈

bluetooth.active(1)               # 啟用並廣播名稱
bluetooth.advertise(100, 'Lynn')

while True:                 
    cmd = bluetooth.read()        # 取得手機傳送過來的指令
    if cmd != b'':
        print(cmd)
    if cmd.startswith(b'ON'):     # 指令：ON
        led.value(1)              # 亮燈
        bluetooth.write("LED on") # 回饋資訊給手機
    elif cmd.startswith(b'OFF'):  # 指令：OFF
        led.value(0)              # 熄燈
        bluetooth.write("LED off")# 回饋資訊給手機
        