import bluetooth                  # 匯入藍牙模組         
from machine import Pin,PWM       # 匯入 Pin,PWM 類別

led = Pin('C13', Pin.OUT)         # 建立 Pin 物件
led.value(0)                      # 預設熄燈
fan = PWM(2,200,0)                # 建立 PWM 物件,預設停止

bluetooth.active(1)               # 啟用藍芽
bluetooth.advertise(100, 'Lynn')  # 藍芽廣播名稱

while True:                 
    cmd = bluetooth.read()        # 取得手機傳送過來的指令
    if cmd != b'':
        print(cmd)
    if cmd.startswith(b'ON'):     # 指令：ON
        fan.duty(500)             # 轉動風扇
        led.value(1)              # 亮燈
        bluetooth.write("FAN on") # 回饋資訊給手機
    elif cmd.startswith(b'OFF'):  # 指令：OFF
        fan.duty(0)               # 停止風扇
        led.value(0)              # 熄燈
        bluetooth.write("FAN off")# 回饋資訊給手機
        