from machine import Pin         # 匯入Pin類別
from gpb import delay           # 匯入delay函式

led=Pin('C13',Pin.OUT)           # 建立控制 LED 的腳位
led.value(0)                    # 熄滅 LED
btn=Pin(15,Pin.IN)            # 建立讀取按鈕的腳位
prev = 0                        # 上一次的按鈕狀態
led_state = 0                   # 預設熄燈

while True:                     # True 代表成立
    curr = btn.value()          # 取得按鈕狀態
    if prev == 0 and curr == 1: # 如果前次沒按且現在按下
        delay(20)               # 等 20 毫秒彈跳結束
        curr = btn.value()      # debounce連續讀值兩次
        if curr == 1:           # 仍然是按下的狀態
            if led_state == 1:  # 互為倒數
                led_state = 0
            else:
                led_state = 1
            led.value(led_state)
    prev = curr                 # 記錄本次狀態