from machine import Pin
from gpb import delay,timer                 # 匯入計時器類別

led = Pin('C13',Pin.OUT)                    # 建立控制LED的腳位
led.value(0)                                # 熄滅LED
btn = Pin(15,Pin.IN)                      # 建立讀取按鈕的腳位
prev = 0                                    # 上一次的按鈕狀態
curr = 0                                    # 目前按鈕狀態
led_state = 0

def switch_led(t):                          # 計時喚醒時要執行的動作
    global prev                             # 使用外面的 prev 名稱
    global curr                             # 使用外面的 curr 名稱
    global led_state
    curr = btn.value()                      # 讀取目前按鈕狀態
    if prev == 0 and curr == 1:                 # 之前沒按現在按了
        led_state=1-led_state
    prev=curr                               # 記錄按鈕狀態
    
led_timer = timer(1)                        # 建立 1 號計時器
led_timer.init(freq=20,callback=switch_led) # 指定每秒喚醒 50 次, 也就是每 20 毫秒 1 次

while True:
    delay(100)                                # 要 delay 計時器才能運作
    if led_state==1:
        led.value(1)
    else:
        led.value(0)