import voice_recognition
import audio_decode,audio_encode
from gpb import delay
from machine import Pin,PWM

L  = Pin("F2",Pin.OUT)
L1 = Pin("F1",Pin.OUT)
L2 = Pin("F0",Pin.OUT)
fan = PWM(2,200,0)
fan_InB=Pin(3,Pin.OUT)
fan_InB.value(1)

L.value(1)
L1.value(1)
L2.value(1)
fan_value=400

voice_recognition.load_database('tinkaVR.bin')# 載入擴充數據庫
delay(500)
voice_recognition.start(10)                 # 啟用10號口令集            
audio_decode.init()                         # 啟用音效模組
#cmd_id=voice_recognition.get_id()           # 取得辨識ID
#audio_encode.init()

while True:
    cmd_id=voice_recognition.get_id()       # 取得辨識ID
    if cmd_id == 1:                         # 口令:播放音樂
        print("music start!")
        audio_decode.start('IU.mp3')
    elif cmd_id == 2:                      # 口令:停止音樂
        audio_decode.stop()                # 關閉音效模組
        print("music stop!")
    elif cmd_id == 10:                     # 口令:增加音量
        audio_decode.volume_up(10)
        print("volume up!")
    elif cmd_id == 11:
        audio_decode.volume_down(10)       # 口令:降低音量
        print("volume down!")
    elif cmd_id == 3:
        L2.value(0)                        # 口令:打開電燈
        print("LED ON!")
    elif cmd_id == 4:
        L2.value(1)                        # 口令:關閉電燈
        print("LED OFF!")
    elif cmd_id == 5:
        fan.duty(fan_value)                # 口令:打開風扇
        delay(2000)
        print("Fan ON!")
    elif cmd_id == 6:
        fan_value += 200
        fan.duty(fan_value)                # 口令:提高風速
        print("speed high"+str(fan_value))
    elif cmd_id == 7:
        fan_value -= 200
        fan.duty(fan_value)                # 口令:降低風速
        print("speed low"+str(fan_value))
    elif cmd_id == 8:
        fan.duty(0)                        # 口令:關閉風扇
        print("Fan ON!")
    elif cmd_id == 13:                     # 口令:開啟錄音
        voice_recognition.stop()
        audio_encode.init()
        audio_encode.start('record.wav')
        print("recording...")
        delay(5000)
        print("STOP recording")
        audio_encode.stop()
        voice_recognition.start(10)
    elif cmd_id == 14:                     # 口令:播放錄音
        audio_decode.start('record.wav')
        print("playing record")